<?php defined('SYSPATH') or die('No direct script access.');

class Task_Helper extends Controller {

    public static function getImportClient(){
        return Task_Helper::getInitClient(
            'init.ip.import'
        );
    }

    public static function getAdminClient(){
        return Task_Helper::getInitClient(
            'init.ip.admin'
        );
    }

    public static function getSrwClient(){
        return Task_Helper::getInitClient(
            'init.ip.srw'
        );
    }

    public static function getInitClient($config_name){
        return Task_Helper::getClient(
	        Kohana::$config->load($config_name)
        );
    }

    public static function getClient($host = NULL){
	    if(is_null($host)){
		    $host = Kohana::$config->load('init.ip.gearman');
	    }
        $client = new GearmanClient();
        $client->addServer($host, 4730);
        return $client;
    }

    public static function createWorker($name, &$class, $function = 'Worker', $count = 1000){
        Kohana::$profiling = false;
        Log::$write_on_add = true;
        
        $worker = new GearmanWorker();
        $worker->addServer(Kohana::$config->load('init.ip.gearman'), 4730);
        $worker->addFunction($name, array($class, $function));
        for($i = 0; $i < $count; $i++){
            $worker->work();
        }
    }

    public static function addFunc($client, $name, $data){
        $client->addTask($name, $data);
        $client->runTasks();
    }

	public static function locationToInt($str){
		return intval(ord($str{0}) << 8) + ord($str{1});
	}

	public static function locationToStr($int){
		return chr($int >> 8) . chr($int % 256);
	}

    public static function getSuffix(){
        $file = 'tlds-alpha-by-domain.txt';
        $file_path = APPPATH.$file;

        /* update suffix list */
        if(!file_exists($file_path)) {
            self::download($file, $file_path);
        }else{
            preg_match('#Last Updated (.*)#', file($file_path)[0], $matches);
            $time = strtotime($matches[1]);
            $now = time();
            $diff = ($now - $time) / Date::MONTH;
            if($diff > 6){
                self::download($file, $file_path);
            }
        }

        /* load suffix list */
        $suffix = file($file_path);
        unset($suffix[0]);
        $suffix = array_reverse(array_map('mb_strtolower', $suffix));
        return str_replace("\n",'', $suffix);
    }

    private static function download($file, $file_path){
        $response = Request::factory('http://data.iana.org/TLD/'.$file)
            ->method('GET')
            ->execute();

        file_put_contents($file_path, $response->body());
    }
}